/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class LivingArmourUpgradeInfoTable
implements IComponentProcessor {
    private ResourceLocation upgradeID;
    private String extraText = "";

    public void setup(IVariableProvider variables) {
        ResourceLocation id = new ResourceLocation(variables.get("upgrade").asString());
        if (LivingArmorRegistrar.UPGRADE_MAP.containsKey(id)) {
            this.upgradeID = id;
        } else {
            LogManager.getLogger().warn("Guidebook given invalid Living Armour Upgrade ID {}", (Object)id);
        }
        if (variables.has("text")) {
            this.extraText = variables.get("text").asString();
        }
    }

    public IVariable process(String key) {
        if (this.upgradeID == null) {
            return null;
        }
        if (key.equals("table")) {
            StringBuilder output = new StringBuilder();
            String i18nLevel = TextHelper.localize("guide.patchouli.bloodmagic.living_armour_upgrade_table.level", new Object[0]);
            String i18nUpgradePoints = TextHelper.localize("guide.patchouli.bloodmagic.living_armour_upgrade_table.upgrade_points", new Object[0]);
            for (Map.Entry<ResourceLocation, LivingUpgrade> entry : LivingArmorRegistrar.UPGRADE_MAP.entrySet()) {
                if (!entry.getKey().equals((Object)this.upgradeID)) continue;
                LivingUpgrade upgrade = entry.getValue();
                int maxLevel = upgrade.getLevel(Integer.MAX_VALUE);
                int maxLevelLength = Integer.toString(maxLevel).length();
                int maxUpgradePointsLength = Integer.toString(upgrade.getLevelCost(maxLevel)).length();
                int exp = 0;
                while ((exp = upgrade.getNextRequirement(exp)) != 0) {
                    int level = upgrade.getLevel(exp);
                    int upgradePoints = upgrade.getLevelCost(level);
                    String formatStr = String.format("%s %%%dd: %%%dd %s$(br)", i18nLevel, maxLevelLength, maxUpgradePointsLength, i18nUpgradePoints);
                    output.append(String.format(formatStr, level, upgradePoints));
                }
            }
            output.append(String.format("%s%s", "$(br2)", this.extraText));
            return IVariable.wrap((String)output.toString());
        }
        return null;
    }
}

